(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6190,        171]*)
(*NotebookOutlinePosition[      6958,        198]*)
(*  CellTagsIndexPosition[      6914,        194]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Normas para entregar los ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " ",
  StyleBox["Identificaci\[OAcute]n del cuaderno.",
    FontWeight->"Bold"],
  " Este cuaderno se llama \"evaluacion1.nb\". Debes renombrarlo. Para ello \
vas a File\[Rule] Save As... y al guardarlo (debes guardarlo en el \
escritorio) le pones tus apellidos y nombre terminado en 1 (en ese orden) \
todo seguido, en min\[UAcute]sculas y sin acentos. Por ejemplo, si te llamas \
Luis G\[OAcute]mez Ruiz debes llamar a tu archivo gomezruizluis1.nb\n",
  StyleBox["2 Comprobaci\[OAcute]n de comandos",
    FontWeight->"Bold"],
  ". Antes de entregar tu examen debes comprobar todos y cada uno de los \
comandos que has usado. Si alguno no funciona correctamente y no sabes \
corregirlo debes indicar claramente que el comando que has escrito no \
funciona correctamente. Si al ejecutar un comando se llena la pantalla de \
mensajes de error o se cuelga el ordenador, el ejercicio correspondiente ser\
\[AAcute] calificado con 0. \n",
  StyleBox["3 Borrar salidas y guardar",
    FontWeight->"Bold"],
  ". Cuando termines tu trabajo es muy importante que borres todas las \
salidas antes de guardar el cuaderno. Para ello vas a Kernel \[Rule] Delete \
all Output. \n",
  StyleBox["4 Entrega del examen",
    FontWeight->"Bold"],
  ". Entras en el SWAD (swad.ugr.es) vas a Asignatura\[Rule]An\[AAcute]lisis \
Mat.(B)\[Rule]Evaluaci\[OAcute]n\[Rule]Mis trabajos y seguidamente \
seleccionas tu archivo que antes has guardado en el escritorio y lo mandas."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normas del examen", "Subsection"],

Cell[TextData[{
  StyleBox[
  "Puedes usar la ayuda del programa y tambi\[EAcute]n los cuadernos de ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[
  " que contienen las pr\[AAcute]cticas y el trabajo que t\[UAcute] hayas \
realizado sobre ellas (los ejercicios que hayas resuelto y tus notas \
personales). Nada m\[AAcute]s. ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aqu\[IAcute] pones tu nombre", "Subsection"],

Cell[BoxData[
    \(Nombre : \n
      \(Titulaci\[OAcute]n\  : \ 
        Ing . \ T\[EAcute]c . \ Inf . \ Sistemas\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  StyleBox[
  "En este ejercicio no debes hacer c\[AAcute]lculos simb\[OAcute]licos. "],
  StyleBox["Todos",
    FontSlant->"Italic"],
  StyleBox[
  " los resultados deben ser valores aproximados.\na) Crea una lista, que \
llamar\[AAcute]s \"lista1\", que empiece en 0 y termine en 1 con incrementos \
de "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/200\)]]],
  StyleBox[
  ".\nb) Transforma lista1 en otra lista, que llamar\[AAcute]s \"lista2\", en \
la que cada elemento x\[Element]lista1 se ha reemplazado por "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/\(x\^3 + 1\)\)]]],
  StyleBox[
  ".\nc) Forma una lista, que llamar\[AAcute]s \"lista3\", de pares de la \
forma {x,y} donde x\[Element]lista1, y\[Element]lista2 son elementos que \
ocupan el mismo lugar en sus respectivas listas.\nd) Define la \
funci\[OAcute]n (x,y) \[RightTeeArrow] "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(x - y\)\/\(1 + x\^2 + y\^2\)\)]]],
  StyleBox[
  " y la eval\[UAcute]as en los elementos de lista3 y a la lista resultante \
la llamas \"lista4\".\ne) Selecciona en lista4 los elementos mayores que "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(-1\)\/7\)]]],
  StyleBox[" y menores que "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`1\/7\)]]],
  StyleBox[
  ".\nf) Suma los cuadrados de los elementos de la lista obtenida en el \
apartado anterior."]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell["\<\
En este ejercicio debes hacer una animaci\[OAcute]n gr\[AAcute]fica. Para \
ello representa gr\[AAcute]ficamente las funciones sen(n x) - n cos(2 n x) en \
el intervalo [-Pi,Pi] para valores de n=1,2,3,4,5. Las gr\[AAcute]ficas deben \
tener color azul y grosor 0.007. Debes fijar el mismo rango para todas ellas. \
Sobre cada gr\[AAcute]fica debes representar los puntos (t, sen(n t) - n \
cos(2 n t)) para t variando desde -3 a 3 con incrementos de 1. Dichos puntos \
deben tener tama\[NTilde]o 0.02 y color rojo.\
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{961, 594},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 57, 0, 56, "Subsection"],
Cell[1791, 53, 1525, 29, 262, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3353, 87, 39, 0, 56, "Subsection"],
Cell[3395, 89, 457, 13, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3889, 107, 50, 0, 56, "Subsection"],
Cell[3942, 109, 129, 3, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4108, 117, 33, 0, 56, "Subsection"],
Cell[4144, 119, 1418, 34, 267, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5599, 158, 33, 0, 56, "Subsection"],
Cell[5635, 160, 539, 8, 75, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

